# SQL vs NoSQL

- SQL은 `Structured Query Language`의 약자로, 구조화 쿼리 언어이다.
- 즉, SQL은 관계형 데이터베이스 관리 시스템(RDBMS)의 데이터를 관리하기 위해 설계된 특수 목적의 프로그래밍 언어이다.
- 반면 NoSQL은 `Not Only SQL`의 약자로 구조화되지 않은 데이터 혹은 동적 데이터를 처리하는데 주로 사용된다.
 
> DB는 SQL로 만들어졌기 때문에 SQL이 관계형 DB라는 의미로 주로 사용된다.

</br>

## **SQL DB(관계형 데이터베이스)**  
- SQL을 사용하여 `RDBMS`에서 데이터를 저장, 수정, 삭제 및 검색할 수 있다.  
- 이러한 `RDB`의 데이터는 엄격한 데이터 스키마를 따라 `DB` 테이블에 저장되며, 관계를 통해 연결된 여러 개의 테이블에 분산되는 특징이 있다.

</br>

### **엄격한 스키마**  
- 데이터는 테이블에 레코드(Rows)로 저장되며, 각 테이블에는 명확하게 정의된 구조가 있다.  
- 구조란 어떤 데이터가 테이블에 추가될 수 있고, 추가될 수 없는지를 정의하는 필드 집합을 의미한다.
- `RDB`에서는 스키마 구조를 준수하지 않는 레코드는 추가할 수 없다. 

</br>

<img width="600" alt="스크린샷 2022-12-22 오후 11 46 02" src="https://user-images.githubusercontent.com/70997596/209167010-9e7d6642-2e59-4699-8975-906f165c7a75.png">

### **관계**  
- SQL 기반 데이터베이스의 또 다른 중요한 특징이다.
- `RDB`는 테이블 간의 관계를 나타내기 위해 **외래 키**를 사용한다.
- 또한, 데이터들을 여러 개의 테이블에 나누어서 저장하므로써 데이터들의 중복을 피할 수 있다.

> 데이터를 나누어서 저장하면 테이블에서 중복 없이 하나의 데이터만을 관리하기 때문에, 다른 테이블에서 부정확한 데이터를 다룰 위험이 줄어드는 장점이 있다.

</br>

<img width="600" alt="스크린샷 2022-12-22 오후 11 58 13" src="https://user-images.githubusercontent.com/70997596/209167045-dc7738e6-2ad3-494a-bc47-529b6f5f3fa1.png">


## **NoSQL DB(비 관계형 데이터베이스)**  
- `NoSQL DB`는 기본적으로 `SQL DB`와 반대되는 접근 방식을 따르기 때문에 지어진 이름이다.
  - 관계형 데이터 모델을 지양한다.
  - 대량의 분산된 데이터를 저장하고, 조회하는데 주로 사용한다.
  - `SQL DB`와 달리 스키마 구조와 다른 데이터를 추가할 수 있다.

</br>

### **NoSQL의 종류**  
- `NoSQL DB`의 종류는 키-값 데이터베이스, 도큐먼트 데이터베이스, 그래프 데이터베이스 등으로 나뉜다.

</br>

1. **키-값 데이터 베이스**
   - 키와 값으로 구성된 배열 구조의 DB로 `NoSQL DB` 중 가장 단순한 구조다.
   - 복잡한 조회 연산은 지원하지 않고, 질의 속도가 빠르다.
   - 대표적인 모델로 `Redis`, `Amazon Dynamo DB` 가 있다.
     
</br>

2. **도큐먼트 데이터베이스**
   - 키와 도큐먼트의 형태로 구성된 DB로 도큐먼트는 계층적인 구조를 가진다.
   - 질의 결과가 JSON, XML 형태로 출력된다.
   - 대표적인 모델로 `MongoDB`, `CouthDB`가 있다.

</br>

3. **그래프 데이터베이스**
   - 그래프 구조를 사용하여 개체와 관계를 표현한 관계형 모델 DB이다.
   - 대표적인 모델로 `Neo4J`가 있다.

<img width="600" alt="스크린샷 2022-12-22 오후 11 57 58" src="https://user-images.githubusercontent.com/70997596/209167086-0ee633fc-c170-4ce1-9965-11ccbd291568.png">

</br>

### **NoSQL의 특징**  
- 유연성 : 스키마 선언 없이 필드의 추가 및 삭제가 자유로운 `Schema-free` 구조다.
- 확장성 : 스케일 아웃에 의한 서버 확장이 용이하다.
- 고성능 : 대용량 데이터를 처리하는 성능이 뛰어나다.
- 가용성 : 여러 대의 백업 서버 구성이 가능하여 장애 발생 시에도 무중단 서비스가 가능하다.

> 수직적 확장 : DB 서버의 성능을 확장하는 것이다.  
> 수평적 확장 : 서버가 더 추가되고, DB를 분산하는 것이다.   
> `SQL DB`는 수직적 확장, `NoSQL DB`는 수직적 확장, 수평적 확장 모두 가능하다.


</br>

## **장단점** 

### **SQL DB의 장점**
- 명확하게 정의된 스키마를 사용하고, 데이터 무결성을 보장한다.
- 관계를 이용해 각 데이터를 중복 없이 한번만 저장한다.

</br>

### **NoSQL DB의 장점**  
- 스키마가 없기 때문에, 언제든지 저장된 데이터를 변경하고 새로운 **필드**를 추가 할 수 있다.
- 데이터를 애플리케이션이 필요로 하는 형식으로 저장할 수 있다. 
- 수직 및 수평 확장이 가능하므로 애플리케이션에서 요청된 모든 읽기, 쓰기를 처리 할 수 있다.

</br>

### **SQL DB의 단점**  
- `NoSQL DB`에 비해 상대적으로 덜 유연하다. (추후에 수정하기가 번거롭거나 불가능 할 수 있다.)
- 관계를 맺고 있기 때문에, `JOIN`이 많은 복잡한 쿼리가 만들어 질 수 있다.
- 수평적 확장이 어렵고, 수직적 확장만 가능하다.

</br>

### **NoSQL DB의 단점**  
- 유연성 때문에, 데이터 구조 결정을 하지 못하고 미루게 될 수 있다.
- 데이터가 여러 테이블에 중복되어 있기 때문에, 수정해야 하는 경우 모든 컬렉션에서 수행 해야 한다.

</br>

---- 

## 출처
https://velog.io/@thms200/SQL-vs-NoSQL  
https://academind.com/tutorials/sql-vs-nosql  
https://siyoon210.tistory.com/130  
https://www.integrate.io/ko/blog/the-sql-vs-nosql-difference-ko/
